/**
 * Plugin: equalbox
 * 
 * Version: 1.0
 * (c) Copyright 2011, Jose Erlino Lontok and Myhedspace.com
 * 
 * Description: A simple jQuery solution that will make sure that related and adjacent columns are of the same height. 
 *
 **/

(function( $ ){
    $.fn.equalbox = function() {
    
        var bigHeight =0;
        
        $(this).each(function () {
            $this = $(this);
            if ( $this.outerHeight() > bigHeight ) {
                bigHeight=$this.outerHeight();
            }
        });        
        
        return $(this).css("height", bigHeight);
    
    };
})( jQuery );

(function($){
    var maxLoop = 5;
    function equalizeBoxHeight() {
        $("#main_contents").height("");
        $("#sidemenu").height("");
        var leftHeight = $("#main_contents")[0].offsetHeight;
        var rightHeight = $("#sidemenu")[0].offsetHeight;
        var paddingTop = $("#main_contents").css("padding-top");
        paddingTop = (paddingTop)? paddingTop.replace("px", ""): 0;
        var height = (leftHeight > rightHeight)? leftHeight - paddingTop : rightHeight - paddingTop;
        $("#main_contents").height(height + "px");
        $("#sidemenu").height(height + "px");
    };
    var t = setInterval(function(){
        if (1 > maxLoop) clearInterval(t);
        equalizeBoxHeight();
        maxLoop--;
    }, 2000);
})(jQuery);